<?php
namespace Elementor;

class wppost extends Widget_Base {
	
	public function get_name() {
		return 'wppost';
	}
	
	public function get_title() {
		return 'اسلایدر مطالب 3';
	}
	
  public function get_icon() {
		return 'eicon eicon-post-content';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }
	
	protected function register_controls() {

		$post_cat = array();
		$categories = get_terms("category");
		if ( !empty( $categories ) && !is_wp_error( $categories ) ){
			foreach ( $categories as $category ) {
				$post_cat[ $category->term_id ] = $category->name;
			}
		}
		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		


		
		$this->add_control(
			'title',
			[
				'label' => 'عنوان',
				'label_block' => true,
				'default' => 'مطالب',
				'type' => Controls_Manager::TEXT,
				'placeholder' => 'عنوان را وارد نمایید',
			]
		);

		$this->add_control(
			'post_sort',
			[
				'label' => 'مرتب سازی مطالب',
				'type' => Controls_Manager::SELECT,
				'default' => 'latest',
				'options' => [
					'latest'  => 'آخرین مطالب',
					'random' => 'مطالب تصادفی',
					'viewed' => 'مطالب پربازدید',
				],
			]
		);

		$this->add_control(
			'post_cat',
			[
				'label' => 'دسته بندی مطالب',
				'type' => Controls_Manager::SELECT2,
				'options' => $post_cat,
			]
		);




		$this->add_control(
			'ptotalcount',
			[
				'label' => 'تعداد مطالب',
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 20,
				'step' => 1,
				'default' => 8,
			]
		);


		$this->end_controls_section();
		
		
        	       $this->start_controls_section(
            'farnam_product_style_1',
            [
                'label' => esc_html__( 'تنظیمات فعال سازی', 'woolentor' ),
            ]
        );

		
	

       $this->add_control(
			'farnamoneshow1',
			[
				'label' => __( 'نمایش تاریخ', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		       $this->add_control(
			'farnamoneshow2',
			[
				'label' => __( 'نمایش دسته بندی', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		

		         $this->add_control(
			'farnamoneshow3',
			[
				'label' => __( 'نمایش نویسنده', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
		'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
			'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		    
		
        $this->end_controls_section();


        
	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
             



		   
		   $this->add_control(
'color_farnam_2',
			[
				'label' => __( 'رنگ پس زمینه تاریخ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .zxtime' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   	   $this->add_control(
'color_farnam_3',
			[
				'label' => __( 'رنگ عدد تاریخ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .zxtime .date-day' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   	   $this->add_control(
'color_farnam_4',
			[
				'label' => __( 'رنگ ماه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .zxtime .date-month' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
	   
		   	   $this->add_control(
'color_farnam_5',
			[
				'label' => __( 'رنگ پس زمینه دسته بندی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .cat-blog-post-401' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		      	   $this->add_control(
'color_farnam_6',
			[
				'label' => __( 'رنگ متن دسته بندی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .cat-blog-post-401 a' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   
			      	   $this->add_control(
'color_farnam_7',
			[
				'label' => __( 'رنگ عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .stitle-401-1 h3' => 'color: {{VALUE}} !important',
				],
			]
           );
				      	   $this->add_control(
'color_farnam_8',
			[
				'label' => __( 'رنگ المان کنار عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .stitle-401-1 h3::before' => 'background: {{VALUE}} !important',
				],
			]
           );	
		   
		   
		   	      	   $this->add_control(
'color_farnam_9',
			[
				'label' => __( 'رنگ متن نویسنده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .tarokh-blog-post-401' => 'color: {{VALUE}} !important',
				],
			]
           );	
		    	      	   $this->add_control(
'color_farnam_10',
			[
				'label' => __( 'رنگ متن ادامه مطلب', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .dokme-edame-blog-401' => 'color: {{VALUE}} !important',
				],
			]
           );	
		   
		   	      	   $this->add_control(
'color_farnam_11',
			[
				'label' => __( 'رنگ المان زیر مطالب', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .post-slider-401-1::before' => 'background: {{VALUE}} !important',
				],
			]
           );	
				  $this->add_responsive_control(
                        'farnamborder3',
                        [
                            'label' => esc_html__( 'گردی دور مطالب', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .post-slider-401-1' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
								
				  $this->add_responsive_control(
                        'farnamborder4',
                        [
                            'label' => esc_html__( 'گردی دور تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .image-post-blog-401' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	
			
								
				  $this->add_responsive_control(
                        'farnamborder5',
                        [
                            'label' => esc_html__( 'گردی تاریخ', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .zxtime' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	
			 $this->add_responsive_control(
                        'farnamborder55',
                        [
                            'label' => esc_html__( 'گردی دسته بندی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .cat-blog-post-401' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	
			
        $this->end_controls_section();


	}
	
	protected function render() {
		global $az_data;
		$settings = $this->get_settings_for_display();
		$post_cat = $settings['post_cat']; ?>
        <div class="rcon">
			<div class="post-block m-product ir99">
		
			<?php
			$post_sort = $settings['post_sort'];
				switch ($post_sort) {
					case 'latest':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
						break;
					case 'viewed':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'meta_key' => 'post_views_count',
						'orderby' => 'meta_value_num',
						'order' => 'DESC'  );
						break;
					case 'random':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'orderby'        => 'rand'  );
						break;
					default:
					$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
					}
					if ( $post_cat ) {
						$args['tax_query'] = array(
							array(
							'taxonomy' => 'category',
							'field' => 'term_id',
							'terms' => $post_cat
							)
						);
					}
				$postsquery = new \WP_Query( $args );
			?>
			
			<?php if ( $postsquery->have_posts() ) { ?>
			<script>
			   $(document).ready(function(){
$('.owl-blog').owlCarousel({
    loop:true,
     autoplay:true,
    autoplayTimeout:7000,
    autoplayHoverPause:true,
    rtl: true,
    nav:true,
	dots:true,
        margin:10,
    dots: false,
    responsive:{
        0:{
            items:1
        },
        700:{
            items:3
        },
        1200:{
            items:4
        }
    }
})
});
</script>
		                   <div class="owl-blog owl-carousel bxboxone">

			<?php while ( $postsquery->have_posts() ) : $postsquery->the_post(); ?>
<div class="post-slider-401-1">
								 								<?php if ( 'yes' === $settings['farnamoneshow1'] ) { ?>

 <span class="zxtime">
<?php echo '<span class="date-day">' . get_the_date( 'd' ) . '</span>';
echo '<span class="date-month">' . get_the_date( 'M' ) . '</span>'; ?>
</span><?php } ?>
<a  href="<?php the_permalink(); ?>">

<div class="image-post-blog-401">
	<?php the_post_thumbnail('medium'); ?>
	</div></a><?php if ( 'yes' === $settings['farnamoneshow2'] ) { ?>
	<div class="cat-blog-post-401">
<?php the_category(', '); ?></div><?php } ?>	<div class="stitle-401-1">
<a  href="<?php the_permalink(); ?>">
	 <h3><?php the_title(); ?></h3></a>
	</div>
<div class="paiin-box-blog-post-box">
<?php if ( 'yes' === $settings['farnamoneshow3'] ) { ?>
<div class="tarokh-blog-post-401"><?php echo get_the_author_meta('display_name'); ?>
</div><?php } ?>
<a href="<?php the_permalink(); ?>" class="dokme-edame-blog-401">ادامه مطلب</a>
</div>
</div>
			<?php endwhile; ?>
				</div>
			<?php 
			} else {		
			echo 'لطفا ابتدا نوشته ای را اضافه نمایید.';}
			wp_reset_postdata();
			?>
			</div>
   		</div>
        <?php

	}

}