<?php
namespace Elementor;

class counterproduct extends Widget_Base {
	
	public function get_name() {
		return 'counterproduct';
	}
	
	public function get_title() {
		return 'تعداد محصولات';
	}
	
 public function get_icon() {
		return 'eicon eicon-menu-bar';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }

	
	protected function register_controls() {


		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'محتوا', 'elementor' ),
			]
		);
		
			$this->add_control(
			'title',
			[
				'label' => __( 'متن تعداد محصول', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'یک متن وارد کنید', 'elementor' ),
			]
		);


$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'list_title',
			[
						'label' => esc_html__( 'عنوان تصویر', 'textdomain' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'default' => esc_html__( 'عنوان اول' , 'textdomain' ),
						'label_block' => true,
					]
		);

		$repeater->add_control(
			'image',
			[
				'name' => 'image',
				'label' => esc_html__( 'تصویر', 'textdomain' ),
								'type' => \Elementor\Controls_Manager::MEDIA,

			]
		);



		$this->add_control(
			'list',
			[
				'label' => esc_html__( 'تصاویر', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_title' => esc_html__( 'تصویر 1', 'textdomain' ),
					],
					[
						'list_title' => esc_html__( 'تصویر 2', 'textdomain' ),
					],
				],
				'title_field' => '{{{ list_title }}}',
			]
		);
		
		
		

			
		$this->end_controls_section();

       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
		
    $this->add_control(
'sepidcolor-1',
			[
				'label' => __( 'رنگ پس زمینه تصاویر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .counter-tedad-product-farvardin-403-box' => 'background: {{VALUE}}  !important',
				],
			]
           );
		   
		
						 

		     $this->add_control(
'sepidcolor-233',
			[
				'label' => __( 'رنگ پس زمینه متن', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .counter-tedad-product-farvardin-403-box-one' => 'background: {{VALUE}} !important',
				],
			]
           );
  $this->add_control(
'sepidcolor-3',
			[
				'label' => __( 'رنگ متن', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .counter-tedad-product-farvardin-403-box-one' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		  
			
		      $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی تصویر اصلی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .counter-tedad-product-farvardin-403-box' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                                '{{WRAPPER}} .counter-tedad-product-farvardin-403-box img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		   

	
		   	      $this->add_responsive_control(
                        'sepidborder-45',
                        [
                            'label' => esc_html__( 'گردی دور متن', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .counter-tedad-product-farvardin-403-box-one' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );

		$this->end_controls_section();
	}







protected function render() {
    $settings = $this->get_settings();

    ob_start();

    ?>
<div class="counter-tedad-product-farvardin-403">

            <?php
            if ($settings['list']) {
                foreach ($settings['list'] as $item) {
                    ?>
                    <div class="counter-tedad-product-farvardin-403-box">
                            <div class="tedad-cat-403-111dfrrcounter-tedad-product-farvardin-403-box">
                                <img src="<?php echo $item['image']['url']; ?>">
                            </div>
                        </a>
                    </div>
                    <?php
                }
            }
            ?>
<div class="counter-tedad-product-farvardin-403-box-one">
<?php echo $settings['title']; ?>
</div>
   </div>
   
    <?php

    echo ob_get_clean();
}


	
	


}
