<?php
namespace Elementor;

class daste extends Widget_Base {
	
	public function get_name() {
		return 'daste';
	}
	
	public function get_title() {
		return 'دسته بندی 1';
	}
	
 public function get_icon() {
		return 'eicon eicon-menu-bar';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }

	
	protected function register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان دسته بندی', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'عنوان خود را وارد کنید', 'elementor' ),
			]
		);
		$this->add_control(
			'darsad',
			[
				'label' => __( 'زیر عنوان دسته بندی', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'زیر عنوان را وارد کنید', 'elementor' ),
			]
		);
		
				$this->add_control(
			'icon',
			[
				'label' => __( 'ایکون material design icons', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'کد ایکون را وارد کنید', 'elementor' ),
			]
		);

						$this->add_control(
			'link',
			[
				'label' => __( 'لینک دسته بندی', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'لینک را وارد کنید', 'elementor' ),
			]
		);
		$this->end_controls_section();
		
		
      
		

        
	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
             

$this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ پس زمینه ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'title_color55',
			[
				'label' => __( 'رنگ متن اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
	
				'selectors' => [
					'{{WRAPPER}} .category-111-box h3' => 'color: {{VALUE}}',
				],
			]
		);
			$this->add_control(
			'title_color525',
			[
				'label' => __( 'رنگ زیر عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
		
				'selectors' => [
					'{{WRAPPER}} .category-111-box h5' => 'color: {{VALUE}}',
				],
			]
		);
$this->add_control(
			'title_color_1',
			[
				'label' => __( 'رنگ پس زمینه ایکون ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);

$this->add_control(
			'title_color_1443',
			[
				'label' => __( 'رنگ ایکون ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .category-111 i' => 'color: {{VALUE}}',
				],
			]
		);
		
$this->add_control(
			'title_color_2',
			[
				'label' => __( 'رنگ سایه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		   
		   $this->add_responsive_control(
                        'farnamborder1',
                        [
                            'label' => esc_html__( 'گردی دور دسته بندی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .category-111' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );

 
        $this->end_controls_section();
		
		
	}
	
	protected function render() {

        $settings = $this->get_settings_for_display();
		echo  "<a class='category-111' href='$settings[link]' style='background: $settings[title_color]; box-shadow: 0 5px 15px $settings[title_color_2];'>
	
		<i class='mdi $settings[icon]' style='background: $settings[title_color_1];'></i>
		<div class='category-111-box'>
		<h3>$settings[title]</h3>
		<h5>$settings[darsad] </h5>
		</div>
		</a>
		
		";
		 

	}
	
	protected function _content_template() {

    }
	
	
}