<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

add_action( 'init', 'wast_register_ticket_type_tax' );
add_action( 'ticket-type_add_form_fields', 'wast_ticket_type_add_mtb', 10, 2 );
add_action( 'ticket-type_edit_form_fields', 'wast_ticket_type_edit_mtb', 10, 2 );
add_action( 'create_ticket-type', 'wast_ticket_type_save_mtb', 10, 2 );
add_action( 'edited_ticket-type', 'wast_ticket_type_save_mtb', 10, 2 );
add_filter( 'manage_edit-ticket-type_columns', 'wast_ticket_type_create_column' );
add_filter( 'manage_ticket-type_custom_column', 'wast_ticket_type_column_content', 10, 3 );

/**
 * Register ticket-type taxonomy
 */
function wast_register_ticket_type_tax() {
	$labels = array(
		'name'              => 'دسته تیکت',
		'singular_name'     => 'دسته تیکت',
		'search_items'      => 'جستجوی دسته‌های تیکت',
		'all_items'         => 'همه دسته‌های تیکت',
		'parent_item'       => 'دسته تیکت مادر',
		'parent_item_colon' => 'دسته تیکت مادر :',
		'edit_item'         => 'ویرایش دسته تیکت',
		'update_item'       => 'به روز رسانی دسته تیکت',
		'add_new_item'      => 'اضافه کردن دسته تیکت جدید',
		'new_item_name'     => 'نام دسته تیکت جدید',
		'menu_name'         => 'دسته‌های تیکت',
		'not_found'         => 'دسته تیکتی یافت نشد!'
	);
	$args   = array(
		'hierarchical'      => true,
		'labels'            => $labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'query_var'         => true,
		'rewrite'           => array( 'slug' => 'ticket-type' ),
	);
	register_taxonomy( 'ticket-type', array( 'ticket' ), $args );
}

/**
 * Display CMB in new tax page
 */
function wast_ticket_type_add_mtb() {
	?>
    <div class="form-field term-name-wrap">
        <label for="recipient-email">ایمیل گیرنده تیکت</label>
        <input name="recipient-email" id="recipient-email" type="email" dir="ltr">
    </div>
	<?php
}

/**
 * Display CMB in edit tax page
 */
function wast_ticket_type_edit_mtb( $term ) {
	$term_id = $term->term_id;

	$recipient_email = get_term_meta( $term_id, '_wast_recipient_email', true );
	$user            = get_user_by( 'email', $recipient_email );
	$html            = '';
	if ( $user ) {
		$html = '<a href="' . get_edit_user_link( $user->data->ID ) . '" target="_blank">' . $user->user_login . '</a>';
	}
	?>
    <tr class="form-field term-name-wrap">
        <th scope="row"><label for="recipient-email">ایمیل گیرنده تیکت</label></th>
        <td>
            <input name="recipient-email" id="recipient-email" type="email" value="<?php echo esc_attr( $recipient_email ); ?>" dir="ltr">
            <p><?php echo $html; ?></p>
        </td>
    </tr>
	<?php
}

/**
 * Save tax CMB
 *
 * @param $term_id
 */
function wast_ticket_type_save_mtb( $term_id ) {
	$recipient_email = $_POST['recipient-email'];

	if ( isset ( $recipient_email ) && ! empty( $recipient_email ) ) {
		update_term_meta( $term_id, '_wast_recipient_email', sanitize_text_field( $recipient_email ) );
	} else {
		delete_term_meta( $term_id, '_wast_recipient_email' );
	}
}

/**
 * Add extra column for tax
 *
 * @param $columns
 *
 * @return mixed
 */
function wast_ticket_type_create_column( $columns ) {
	$columns['recipient_email'] = 'گیرنده';

	return $columns;
}

/**
 * Extra column content
 *
 * @param $content
 * @param $column_name
 * @param $term_id
 *
 * @return mixed
 */
function wast_ticket_type_column_content( $content, $column_name, $term_id ) {
	$recipient_email = get_term_meta( $term_id, '_wast_recipient_email', true );
	$user            = get_user_by( 'email', $recipient_email );

	$html = $recipient_email;
	if ( $user ) {
		$html = '<a href="' . get_edit_user_link( $user->data->ID ) . '" target="_blank">' . $user->user_login . '</a>';
	}
	switch ( $column_name ) {
		case 'recipient_email':
			echo $html ? $html : '—';
			break;
	}

	return $content;
}