<?php
namespace Elementor;

class catalogsingle extends Widget_Base {
	
	public function get_name() {
		return 'catalogsingle';
	}
	
	public function get_title() {
		return 'کاتالوگ و بروزرسانی';
	}
	
 public function get_icon() {
		return 'eicon eicon-document-file';
    }
    
    public function get_categories() {
        return [ 'farnamproduct' ];
    }

	
	protected function register_controls() {


		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'محتوا', 'elementor' ),
			]
		);
		
	
		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'عنوان', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'دانلود کاتالوگ', 'plugin-name' ),
				'placeholder' => esc_html__( 'یک عنوان وارد کنید', 'plugin-name' ),
			]
		);

$this->add_control(
			'farnamoneshow1',
			[
				'label' => __( 'نمایش تاریخ بروزرسانی', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);


		$this->end_controls_section();
		
		
  $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );


		    $this->add_control(
'sepidcolor-2',
			[
				'label' => __( 'پس زمینه ایکون کاتالوگ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} #esalat-single-product-43534 .meta-catalog-date-box:first-child' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'sepidcolor-2rd2',
			[
				'label' => __( 'رنگ کادر باکس کاتالوگ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} #esalat-single-product-43534 .meta-catalog-date-box:first-child' => 'border-color: {{VALUE}} !important',
				],
			]
           );
		      $this->add_control(
'sepidcolor-3',
			[
				'label' => __( 'رنگ ایکون کاتالوگ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} #esalat-single-product-43534 .meta-catalog-date-box:first-child i' => 'color: {{VALUE}} !important',
				],
			]
           );
		   



		
		  $this->add_control(
'sepidcolor-4',
			[
				'label' => __( 'رنگ عنوان کاتالوگ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} #esalat-single-product-43534 .meta-catalog-date-box:first-child' => 'color: {{VALUE}} !important',
				],
			]
           );
		   	      $this->add_control(
'sepidcolor-555',
			[
				'label' => __( 'رنگ پس زمینه بروزرسانی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} #esalat-single-product-43534 .meta-catalog-date-box:nth-child(2)' => 'background: {{VALUE}} !important',
				],
			]
			      );
			     $this->add_control(
'sepidcolor-5555',
			[
				'label' => __( 'رنگ کادر باکس بروزرسانی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} #esalat-single-product-43534 .meta-catalog-date-box:nth-child(2)' => 'border-color: {{VALUE}} !important',
				],
			]      );
		   	      $this->add_control(
'sepidcolor-5',
			[
				'label' => __( 'رنگ متن بروزرسانی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} #esalat-single-product-43534 .meta-catalog-date-box:nth-child(2)' => 'color: {{VALUE}} !important',
				],
			]
           );
		         $this->add_control(
'sepidcolor-54645',
			[
				'label' => __( 'رنگ ایکون بروزرسانی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} #esalat-single-product-43534 .meta-catalog-date-box:nth-child(2) i' => 'color: {{VALUE}} !important',
				],
			]
           );
	
		
					 $this->add_responsive_control(
                        'sepidborder-2',
                        [
                            'label' => esc_html__( 'گردی باکس کاتالوگ', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} #esalat-single-product-43534 .meta-catalog-date-box:first-child' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
						 $this->add_responsive_control(
                        'sepidborder-3',
                        [
                            'label' => esc_html__( 'گردی باکس بروزرسانی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} #esalat-single-product-43534 .meta-catalog-date-box' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		$this->end_controls_section();
		
	}
	protected function render() {
		$settings = $this->get_settings_for_display();
defined( 'ABSPATH' ) || exit;

global $product;


				?>
<div class="meta-catalog-date" id="esalat-single-product-43534">
 <?php $option_meta = rwmb_meta('catalog'); if (!empty($option_meta)) { ?>

<a  href="<?php echo $option_meta; ?>" class="meta-catalog-date-box">
<i class="fi fi-rr-download"></i>
<?php echo '' . $settings['title'] . ''; ?>

</a>
<?php } ?>

	 <?php if ( 'yes' === $settings['farnamoneshow1'] ) { ?>
<a class="meta-catalog-date-box">
<i class="fi fi-rr-calendar"></i>
بروزرسانی :                         <?php the_modified_time('Y/m/d'); ?>

</a>
<?php } ?>

</div>
		<?php


	}


	
	protected function _content_template() {

    }
	
	
}