<?php
/*
Plugin Name: تیکت پشتیبانی وردپرس
Plugin URI: 
Description: یک سیستم تیکت فوق العاده
Version: 3.0.0
Author: وردپرس
Author URI: 
*/

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

/**
 * Plugin base class
 */
final class WAST_Support_Ticket {

	/**
	 * Single instance of class
	 * @var null
	 */
	private static $instance = null;

	/**
	 * Get class single instance
	 * @return null|WAST_Support_Ticket
	 */
	public static function get_instance() {
		if ( self::$instance === null ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Create a new object
	 * WAST_Support_Ticket constructor.
	 */
	public function __construct() {
// set the default timezone to use.
		$this->define_constants();

        register_activation_hook( __FILE__, array( $this, 'plugin_activation' ) );
        register_deactivation_hook( __FILE__, array( $this, 'plugin_deactivation' ) );

		add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), array( $this, 'add_action_links' ) );

		add_action( 'wast_auto_close_ticket_event', array( $this, 'auto_close_ticket' ) );

		if ( function_exists( '__autoload' ) ) {
			spl_autoload_register( '__autoload' );
		}
		spl_autoload_register( array( $this, 'autoload' ) );

		$this->load_assets();

		$this->_include();
	}

	/**
	 * Define constants for use entire project
	 */
	private function define_constants() {
		define( 'WAST_VERSION', '13.1.0' );

		define( 'WAST_PATH', trailingslashit( plugin_dir_path( __FILE__ ) ) );
		define( 'WAST_URL', trailingslashit( plugin_dir_url( __FILE__ ) ) );

		define( 'WAST_INC_PATH', trailingslashit( WAST_PATH . 'includes' ) );
		define( 'WAST_CLASS_PATH', trailingslashit( WAST_PATH . 'classes' ) );
		define( 'WAST_TPL_PATH', trailingslashit( WAST_PATH . 'templates' ) );

		define( 'WAST_CSS_URL', trailingslashit( WAST_URL . 'assets/css' ) );
		define( 'WAST_JS_URL', trailingslashit( WAST_URL . 'assets/js' ) );
		define( 'WAST_IMG_URL', trailingslashit( WAST_URL . 'assets/images' ) );
	}

	/**
	 * Include files
	 */
	private function _include() {
		require_once( ABSPATH . 'wp-admin/includes/screen.php' );
		include( WAST_INC_PATH . 'functions.php' );
		include( WAST_INC_PATH . 'hooks.php' );
		include( WAST_INC_PATH . 'ajax.php' );
		include( WAST_INC_PATH . 'ticket-cpt.php' );
		include( WAST_INC_PATH . 'ticket-type-tax.php' );
		include( WAST_INC_PATH . 'pre-answer-cpt.php' );
		include( WAST_INC_PATH . 'admin-menu.php' );
		include( WAST_INC_PATH . 'product-mtb.php' );
		include( WAST_INC_PATH . 'user-mtb.php' );
		include( WAST_INC_PATH . 'ticket-panel.php' );
		include( WAST_INC_PATH . 'dokan-panel.php' );
		include( WAST_INC_PATH . 'shortcodes.php' );
	}

	/**
	 * This function call when plugin is activate
	 */
	public function plugin_activation() {
		if ( get_option( 'wast_version' ) != WAST_VERSION ) {
			update_option( 'wast_version', WAST_VERSION );
		}

		$this->insert_default_options();

		if ( ! wp_next_scheduled( 'wast_auto_close_ticket_event' ) ) {
			wp_schedule_event( strtotime( date( 'Y-m-d 23:00:00' ) ), 'daily', 'wast_auto_close_ticket_event' );
		}
	}

	/**
	 * This function call when plugin is deactivate
	 */
	   public function plugin_deactivation() {
        wp_clear_scheduled_hook( 'wast_auto_close_ticket_event' );
    }



	/**
	 * Auto include all class files in classes path entire project
	 *
	 * @param $class
	 */
	public function autoload( $class ) {
		if ( false !== strpos( $class, 'WAST_' ) ) {
			$class_file = WAST_CLASS_PATH . 'class-' . str_replace( '_', '-', substr( strtolower( $class ), 5 ) ) . '.php';
			if ( is_file( $class_file ) && file_exists( $class_file ) ) {
				include_once $class_file;
			}
		}
	}

	/**
	 * Applied to the list of links to display on the plugins page (beside the activate/deactivate links)
	 *
	 * @param $links
	 *
	 * @return array
	 */
	public function add_action_links( $links ) {
		$links[] = '<a href="' . admin_url( 'edit.php?post_type=ticket&page=wast-options' ) . '">تنظیمات</a>';

		return $links;
	}

	/**
	 * Insert default options for plugin in database
	 */
	private function insert_default_options() {
		if ( ! get_option( 'wast_options' ) ) {
			$options = array(
				'posts-per-page'       => 10,
				'orderby'              => 'date-created',
				'show-icon'            => '1',
				'ticket-order'         => 'desc',
				'active-upload'        => '1',
				'file-max-size'        => '1',
				'active-notifications' => '1',
				'email-subject'        => 'تیکت پشتیبانی جدید',
				'email-sender'         => $_SERVER['HTTP_HOST'] && isset( $_SERVER['HTTP_HOST'] ) ? 'noreply@' . $_SERVER['HTTP_HOST'] : '',
			);

			update_option( 'wast_options', $options );
		}
	}

	/**
	 * Change old ticket status to closed
	 */
	public function auto_close_ticket() {
		$period = wast_get_option( 'auto-close-period' );
		if ( ! intval( $period ) ) {
			return false;
		}

		$period_s = $period * 86400;

		$args  = array(
			'post_type'      => 'ticket',
			'posts_per_page' => - 1,
			'post_status'    => array( 'open', 'in_progress', 'answered' ),
			'meta_query'     => array(
				array(
					'key'     => '_wast_ticket_last_reply_date',
					'value'   => time() - $period_s,
					'compare' => '<',
				),
			),
		);
		$posts = new WP_Query( $args );

		if ( $posts->have_posts() ) {
			while ( $posts->have_posts() ) {
				$posts->the_post();
				$post_ids[] = $posts->post->ID;

				wast_set_post_status( 'closed', $posts->post->ID );
			}
		}
	}

	/**
	 * Load CSS and JS files in front-end
	 */
	public function load_assets() {
		add_action( 'wp_enqueue_scripts', array( $this, 'load_scripts' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'load_admin_scripts' ) );

		$this->wp_footer();
		$this->wp_head();
		$this->admin_footer();
	}

	/**
	 * Register CSS and JS file for front-end
	 */
	public function load_scripts() {
		wp_register_style( 'wast-styles', WAST_CSS_URL . 'styles.css', null, WAST_VERSION );
		wp_enqueue_style( 'wast-styles' );
		wp_register_script( 'wast-scripts', WAST_JS_URL . 'scripts.js', array( 'jquery' ), WAST_VERSION, true );
		wp_enqueue_script( 'wast-scripts' );
		wp_localize_script( 'wast-scripts', 'wast_data', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
	}

	/**
	 * Register CSS and JS file for back-end
	 */
	public function load_admin_scripts() {
		wp_enqueue_media();

		wp_register_style( 'wast-styles', WAST_CSS_URL . 'admin-styles.css', null, WAST_VERSION );
		wp_enqueue_style( 'wast-styles' );
		wp_register_script( 'wast-scripts', WAST_JS_URL . 'admin-scripts.js', array( 'jquery' ), WAST_VERSION, true );
		wp_enqueue_script( 'wast-scripts' );
		wp_localize_script( 'wast-scripts', 'wast_data', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
	}

	/**
	 * Customize head in front-end
	 */
	private function wp_head() {
		add_action( 'wp_head', function () {
			echo '<meta name="_wast_nonce" content="' . wp_create_nonce( 'ajax_nonce' ) . '">' . PHP_EOL;
			if ( wast_get_option( 'custom-css' ) ) {
				echo '<style>' . esc_html( wast_get_option( 'custom-css' ) ) . '</style>' . PHP_EOL;
			}
			if ( wast_get_option( 'support-icon-alignment' ) == 'left' ) {
				echo '<style>#wast-support-icon {right: auto !important;left: 1rem !important;}</style>' . PHP_EOL;
			}
		} );
	}

	/**
	 * Customize footer in front-end
	 */
	private function wp_footer() {
		add_action( 'wp_footer', function () {
			if ( wast_get_option( 'show-icon' ) && is_user_logged_in() ) {
				$ticket_url   = wast_get_ticket_page_url( get_current_user_id() );
				$support_icon = wast_get_option( 'support-icon' );
				$support_icon = $support_icon ? $support_icon : WAST_IMG_URL . 'chat.png';
				echo '<a href="' . add_query_arg( array( 'action' => 'new' ), $ticket_url ) . '" id="wast-support-icon"><img src="' . esc_attr( $support_icon ) . '" alt=""></a>';
			}
		}, 99 );
	}

	/**
	 * Customize footer in back-end
	 */
	private function admin_footer() {
		add_action( 'admin_footer', function () {
			$screen = get_current_screen();
			if ( $screen->base == 'post' && $screen->post_type == 'pre-answer' ) {
				?>
                <script>
                    jQuery(document).ready(function ($) {
                        var menu_posts_ticket = $('#menu-posts-ticket');
                        menu_posts_ticket.addClass('wp-has-current-submenu wp-menu-open');
                        menu_posts_ticket.find('a.menu-icon-ticket').addClass('wp-has-current-submenu wp-menu-open');
                        $('a[href="<edit.php?post_type=pre-answer"]').parentsUntil('ul.wp-submenu').addClass('current');
                    });
                </script>
				<?php
			}
		} );
	}

	public function __clone() {
	}

	public function __wakeup() {
	}
}

WAST_Support_Ticket::get_instance();


/* اضافت به افزونه */


function ticketmbn_print_styles() {
	$rtl_css_url = plugins_url('/assets/css/rtl.css', __FILE__);
	wp_register_style('ticketmbn-rtl', $rtl_css_url, array(), '1.0.0');
	wp_enqueue_style('ticketmbn-rtl');
  }
  
  add_action('wp_print_styles', 'ticketmbn_print_styles');




  /* تعداد تیکت کاربر */
// functions.php یا یک فایل دیگر

function open_tickets_count_shortcode() {
    $open_tickets_count = wast_get_all_open_tickets();

    if ($open_tickets_count > 0) {
        return '<div style="color: #ff0000;">تعداد تیکت‌های باز: ' . $open_tickets_count . '</div>';
    } else {
        return '<div>تعداد تیکت‌های باز: 0</div>';
    }
}
add_shortcode('open_tickets_count', 'open_tickets_count_shortcode');




// تعریف شورتکد
function total_tickets_count_shortcode() {
    global $wpdb;

    $total_tickets_count = $wpdb->get_var("
        SELECT COUNT(ID)
        FROM $wpdb->posts
        WHERE post_type = 'ticket'
    ");

    if ($total_tickets_count > 0) {
        return '<div style="color: #0000ff;">تعداد کل تیکت‌ها: ' . $total_tickets_count . '</div>';
    } else {
        return '<div>تعداد کل تیکت‌ها: 0</div>';
    }
}

// ثبت شورتکد با نام total_tickets_count
add_shortcode('total_tickets_count', 'total_tickets_count_shortcode');




// تعریف شورتکد برای نمایش تعداد کل تیکت‌های کاربر
function user_tickets_count_shortcode() {
    $user_id = get_current_user_id();

    if ($user_id) {
        global $wpdb;

        $user_tickets_count = $wpdb->get_var($wpdb->prepare("
            SELECT COUNT(ID)
            FROM $wpdb->posts
            WHERE post_type = 'ticket' AND post_author = %d
        ", $user_id));

        if ($user_tickets_count > 0) {
            return '<div class="number-ticket-23423">
			<span>' . $user_tickets_count . '</span> تیکت </div>';
        } else {
            return '<div class="number-ticket-23423 no-ticket-12">
			<span>0</span>تیکت </div>';
        }
    }

    return ''; // اگر کاربر وارد سیستم نشده باشد، هیچ مقداری نمایش داده نمی‌شود
}





function wast_get_user_tickets_count($user_id, $status) {
    global $wpdb;

    $query = $wpdb->prepare(
        "SELECT COUNT(ID) FROM $wpdb->posts WHERE post_type = 'ticket' AND post_author = %d AND post_status = %s",
        $user_id,
        $status
    );

    return (int) $wpdb->get_var($query);
}

// ثبت شورتکد با نام user_tickets_count
add_shortcode('user_tickets_count', 'user_tickets_count_shortcode');


function user_open_tickets_count_shortcode() {
    $user_id = get_current_user_id();

    if ($user_id) {
        $open_tickets_count = wast_get_user_tickets_count($user_id, 'open');

        if ($open_tickets_count > 0) {
            return '<div class="number-ticket-23423 bazhast">
			 <span>' . $open_tickets_count . '</span> تیکت باز </div>';
        } else {
            return '<div class="number-ticket-23423 no-ticket-12">
			<span>0</span>تیکت باز </div>';
        }
    }

    return ''; // اگر کاربر وارد سیستم نشده باشد، هیچ مقداری نمایش داده نمی‌شود
}

// ثبت شورتکد با نام user_open_tickets_count
add_shortcode('user_open_tickets_count', 'user_open_tickets_count_shortcode');



/**
 * Get the count of user's answered tickets.
 *
 * @param int $user_id User ID.
 *
 * @return int
 */
function wast_get_user_answered_tickets_count($user_id) {
    return wast_get_user_tickets_count($user_id, 'answered');
}

/**
 * Shortcode to display the count of user's answered tickets.
 */
function user_answered_tickets_count_shortcode() {
    $user_id = get_current_user_id();

    if ($user_id) {
        $answered_tickets_count = wast_get_user_answered_tickets_count($user_id);

        if ($answered_tickets_count > 0) {
            return '<div class="number-ticket-23423 pasokhdade">
			<span>' . $answered_tickets_count . '</span> پاسخ داده شده</div>';
        } else {
            return '<div class="number-ticket-23423 no-ticket-12">
			<span>0</span>پاسخ داده شده</div>';
        }
    }

    return ''; // اگر کاربر وارد سیستم نشده باشد، هیچ مقداری نمایش داده نمی‌شود
}

// ثبت شورتکد با نام user_answered_tickets_count
add_shortcode('user_answered_tickets_count', 'user_answered_tickets_count_shortcode');




function wast_get_user_closed_tickets_count($user_id) {
    return wast_get_user_tickets_count($user_id, 'closed');
}

/**
 * Shortcode to display the count of user's closed tickets.
 */
function user_closed_tickets_count_shortcode() {
    $user_id = get_current_user_id();

    if ($user_id) {
        $closed_tickets_count = wast_get_user_closed_tickets_count($user_id);

        if ($closed_tickets_count > 0) {
            return '<div class="number-ticket-23423 bastesgode">
			<span> ' . $closed_tickets_count . '</span>بسته شده</div>';
        } else {
            return '<div class="number-ticket-23423 no-ticket-12">
			<span>0</span>بسته شده</div>';
        }
    }

    return ''; // اگر کاربر وارد سیستم نشده باشد، هیچ مقداری نمایش داده نمی‌شود
}

// ثبت شورتکد با نام user_closed_tickets_count
add_shortcode('user_closed_tickets_count', 'user_closed_tickets_count_shortcode');


function wast_get_user_pending_tickets_count($user_id) {
    return wast_get_user_tickets_count($user_id, 'in_progress');
}

/**
 * Shortcode to display the count of user's pending tickets.
 */
function user_pending_tickets_count_shortcode() {
    $user_id = get_current_user_id();

    if ($user_id) {
        $pending_tickets_count = wast_get_user_pending_tickets_count($user_id);

        if ($pending_tickets_count > 0) {
            return '<div class="number-ticket-23423 baresishod">
			<span> ' . $pending_tickets_count . '</span>در حال بررسی</div>';
        } else {
            return '<div class="number-ticket-23423 no-ticket-12">
			<span>0</span>در حال بررسی</div>';
        }
    }

    return ''; // اگر کاربر وارد سیستم نشده باشد، هیچ مقداری نمایش داده نمی‌شود
}

// ثبت شورتکد با نام user_pending_tickets_count
add_shortcode('user_pending_tickets_count', 'user_pending_tickets_count_shortcode');