<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

add_action( 'init', 'wast_register_pre_answer_cpt' );
add_action( 'admin_menu', 'wast_pre_answer_submenu_page' );
add_action( 'pre_get_posts', 'wast_filter_pre_answer_posts' );
add_action( 'current_screen', 'wast_restrict_edit_pre_answer_post' );

/**
 * Register pre-answer CPT
 */
function wast_register_pre_answer_cpt() {
	$labels = array(
		'name'               => 'پیش پاسخ',
		'singular_name'      => 'پیش پاسخ',
		'menu_name'          => 'پیش پاسخ‌ها',
		'name_admin_bar'     => 'پیش پاسخ',
		'add_new'            => 'پیش پاسخ جدید',
		'add_new_item'       => 'اضافه کردن پیش پاسخ جدید',
		'new_item'           => 'پیش پاسخ جدید',
		'edit_item'          => 'ویرایش پیش پاسخ',
		'view_item'          => 'نمایش پیش پاسخ',
		'all_items'          => 'همه پیش پاسخ‌ها',
		'search_items'       => 'جستجوی پیش پاسخ‌ها',
		'parent_item_colon'  => 'والد پیش پاسخ‌ها',
		'not_found'          => 'پیش پاسخی یافت نشد!',
		'not_found_in_trash' => 'پیش پاسخی در زباله دان یافت نشد!',
	);
	$args   = array(
		'labels'              => $labels,
		'description'         => 'پیش پاسخ‌ها',
		'public'              => true,
		'publicly_queryable'  => true,
		'show_ui'             => true,
		'show_in_menu'        => false,
		'query_var'           => true,
		'rewrite'             => array( 'slug' => 'pre-answer' ),
		'capability_type'     => 'post',
		'has_archive'         => true,
		'hierarchical'        => true,
		'menu_position'       => 25,
		'supports'            => array( 'title', 'editor' ),
		'menu_icon'           => 'dashicons-list-view',
		'taxonomies'          => array( '' ),
		'exclude_from_search' => true,
	);
	register_post_type( 'pre-answer', $args );
}

/**
 * Show pre-answer CPT menu in admin menu
 */
function wast_pre_answer_submenu_page() {
	add_submenu_page(
		'edit.php?post_type=ticket',
		'پیش پاسخ‌ها',
		'پیش پاسخ‌ها',
		'edit_posts',
		'edit.php?post_type=pre-answer',
		''
	);
}

/**
 * Filter pre-answer posts by author
 * Restrict users to access others posts
 *
 * @param $query
 */
function wast_filter_pre_answer_posts( $query ) {
	if ( is_admin() ) {
		$screen = get_current_screen();
		if ( $screen ) {
			if ( $screen->base == 'edit' && $screen->post_type == 'pre-answer' ) {
				$query->set( 'author', get_current_user_id() );
			}
		}
	}
}

/**
 * Restrict users to edit others posts
 */
function wast_restrict_edit_pre_answer_post() {
	if ( is_admin() ) {
		$screen = get_current_screen();
		if ( $screen->base == 'post' && $screen->post_type == 'pre-answer' ) {
			if ( isset( $_GET['post'] ) && ctype_digit( $_GET['post'] ) ) {
				$post_author_id = get_post_field( 'post_author', $_GET['post'] );
				if ( $post_author_id != get_current_user_id() ) {
					wp_die( 'شما مجوز دسترسی به این صفحه را ندارید!' );
				}
			}
		}
	}
}