<?php
namespace Elementor;

class relatedsingle extends Widget_Base {
	
	public function get_name() {
		return 'relatedsingle';
	}
	
	public function get_title() {
		return 'محصولات مرتبط';
	}
	
 public function get_icon() {
		return 'eicon eicon-product-related';
    }
    
    public function get_categories() {
        return [ 'farnamproduct' ];
    }

	
	protected function register_controls() {


  $this->start_controls_section(
            'farnam_product_style_1',
            [
                'label' => esc_html__( 'تنظیمات فعال سازی', 'woolentor' ),
            ]
        );

		
		       $this->add_control(
			'farnamoneshow1',
			[
				'label' => __( 'نمایش تخفیف', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

    
		
		

        $this->end_controls_section();


		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'محتوا', 'elementor' ),
			]
		);
		
	
		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'عنوان', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'محصولات مرتبط', 'plugin-name' ),
				'placeholder' => esc_html__( 'عنوان مد نظر خود را وارد کنید', 'plugin-name' ),
			]
		);
			

		$this->end_controls_section();
		
		
  $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );

	      $this->add_control(
'sepidcolor-3',
			[
				'label' => __( 'رنگ عنوان اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .first-sepid-product-box.rel-sepid h4' => 'color: {{VALUE}} !important',
				],
			]
           );
		    $this->add_control(
'sepidcolor-2',
			[
				'label' => __( 'رنگ المان کنار عنوان اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .first-sepid-product-box.rel-sepid h4::before' => 'background: {{VALUE}} !important',
				],
			]
           );
		    $this->add_control(
'sepidcolor-2g4',
			[
				'label' => __( 'رنگ کادر مصحولات', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sepid-product-tab-1rrrrtr' => 'border-color: {{VALUE}} !important',
				],
			]
           );
		   
  $this->add_control(
'sepidcolor-5fr1',
			[
				'label' => __( 'رنگ پس زمینه محصولات', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sepid-product-tab-1rrrrtr' => 'background: {{VALUE}} !important',
				],
			]
           );

		
		  $this->add_control(
'sepidcolor-4',
			[
				'label' => __( 'رنگ پس زمینه تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sepid-product-tab-1-boxertert .offer-asliyuy7erter' => 'background: {{VALUE}} !important',
				],
			]
           );
		   	  $this->add_control(
'sepidcolor-4hg',
			[
				'label' => __( 'رنگ متن تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sepid-product-tab-1-boxertert .offer-asliyuy7erter' => 'color: {{VALUE}} !important',
				],
			]
           );
		   	      $this->add_control(
'sepidcolor-5',
			[
				'label' => __( 'رنگ عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sepid-product-tab-1rrrrtr h3' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
	
	
		   
		   $this->add_control(
'sepidcolor-7',
			[
				'label' => __( 'رنگ قیمت', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .risk-meta-pricerterte-98' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .risk-meta-pricerterte-98 ins' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		    $this->add_control(
'sepidcolor-8',
			[
				'label' => __( 'رنگ قیمت تخفیف خورده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .risk-meta-pricerterte-98 del' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
	    $this->add_control(
'sepidcolor-89',
			[
				'label' => __( 'رنگ پس زمینه دکمه اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .owl-ponejyyyy.owl-carousel.owl-rtl.owl-loaded.owl-drag .owl-nav button' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'sepidcolor-894',
			[
				'label' => __( 'رنگ ایکون دکمه اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .owl-ponejyyyy.owl-carousel.owl-rtl.owl-loaded.owl-drag .owl-nav button' => 'color: {{VALUE}} !important',
				],
			]
           ); 
		
		  
				$this->add_responsive_control(
			'title_padding',
			[
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'label' => esc_html__( 'فاصله داخلی', 'textdomain' ),
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .sepid-product-tab-1rrrrtr' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		   
					 $this->add_responsive_control(
                        'sepidborder-2',
                        [
                            'label' => esc_html__( 'گردی باکس محصولات', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .sepid-product-tab-1rrrrtr' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					$this->add_responsive_control(
                        'sepidborder-3',
                        [
                            'label' => esc_html__( 'گردی تخفیف', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .sepid-product-tab-1-boxertert .offer-asliyuy7erter' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					$this->add_responsive_control(
                        'sepidborder-4',
                        [
                            'label' => esc_html__( 'گردی تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .tab-img-sepidertert img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		$this->add_responsive_control(
                        'sepidborder-9',
                        [
                            'label' => esc_html__( 'گردی دکمه اسلایدر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .owl-ponejyyyy.owl-carousel.owl-rtl.owl-loaded.owl-drag .owl-nav button' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
		$this->end_controls_section();
		
	}
	protected function render() {
		$settings = $this->get_settings_for_display();
defined( 'ABSPATH' ) || exit;

				?>

                <script>
				
				        $(document).ready(function(){
$('.owl-ponejyyyy').owlCarousel({
    loop:true,
     autoplay:true,
    autoplayTimeout:7000,
    autoplayHoverPause:true,
    rtl: true,
    nav:true,
	dots:true,
        margin:10,
    dots: false,
    responsive:{
        0:{
            items:1
        },
		  360:{
            items:2
        },
        700:{
            items:3
        },
		   1200:{
            items:4
        },
        1250:{
            items:5
        }
    }
})
});
</script>

<div class="first-sepid-product-box rel-sepid" id="related-single-product-6542s">
<h4> <?php echo '' . $settings['title'] . ''; ?>
</h4>
    <div class="owl-ponejyyyy owl-carousel">

	<?php // بررسی اینکه محصول به درستی مقداردهی شده است
global $product;
if ( ! is_a( $product, 'WC_Product' ) ) {
    $product = wc_get_product(get_the_ID());
}

// اطمینان حاصل کنید که $product به درستی مقداردهی شده است
if ( $product ) {
    $cats_array = array(0); // آرایه‌ای از دسته‌بندی‌ها
    $terms = wp_get_post_terms($product->get_id(), 'product_cat');
    
    foreach ( $terms as $term ) {
        $children = get_term_children($term->term_id, 'product_cat');
        if ( ! sizeof($children) ) {
            $cats_array[] = $term->term_id;
        }
    }

    $args = apply_filters('woocommerce_related_products_args', array(
        'post_type' => 'product',
        'ignore_sticky_posts' => 1,
        'no_found_rows' => 1,
        'posts_per_page' => 8,
        'orderby' => 'rand',
        'meta_query' => array(
            array(
                'key' => '_stock_status',
                'value' => 'instock'
            )
        ),
        'tax_query' => array(
            array(
                'taxonomy' => 'product_cat',
                'field' => 'id',
                'terms' => $cats_array,
            )
        )
    ));
$related_items = new \WP_Query($args);
    if ( $related_items->have_posts() ) : 
        while ( $related_items->have_posts() ) : 
            $related_items->the_post(); ?>

 <div class="sepid-product-tab-3  sepid-single-related">
 <div class="sepid-product-tab-1rrrrtr">

 <div class="sepid-product-tab-1-boxertert">



<a href="<?php the_permalink(); ?>">

	<div class="tab-img-sepidertert">
		
		
	
						<?php if ( 'yes' === $settings['farnamoneshow1'] ) { ?>




	<?php global $product; if( $product->is_on_sale() ) { ?>

	<div class="offer-asliyuy7erter"><?php echo apply_filters( 'woocommerce_sale_flashtwo', $product ); ?>
</div>
<?php } ?><?php } ?><?php the_post_thumbnail('woocommerce_thumbnail'); ?>

</div>
<h3><?php the_title(); ?></h3>
</a>

<div class="list-meta">




<div class="risk-meta-pricerterte-98">
<?php echo $product->get_price_html(); ?>
</div>	
</div>


</div></div></div>
<?php endwhile;
        wp_reset_postdata();
    endif;
}


?></div>
</div>


		<?php


	}


	
	protected function _content_template() {

    }
	
	
}