<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class product111 extends Widget_Base {

    public function get_name() {
        return 'product111';
    }
    
    public function get_title() {
        return __( 'اسلایدر محصولات 10', 'woolentor' );
    }

    public function get_icon() {
		return 'eicon eicon-bag-medium';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }

    public function get_script_depends() {
        return [
            'woolentor-widgets-scripts',
            'slick',
        ];
    }

    protected function register_controls() {


        $this->start_controls_section(
            'woolentor-products',
            [
                'label' => esc_html__( 'تنظیمات محصول', 'woolentor' ),
            ]
        );
                

            $this->add_control(
                'woolentor_product_grid_product_filter',
                [
                    'label' => esc_html__( 'فيلتر شده', 'woolentor' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'recent',
                    'options' => [
                        'recent' => esc_html__( 'آخرين محصولات', 'woolentor' ),
                        'featured' => esc_html__( 'محضولات ويژه', 'woolentor' ),
                        'best_selling' => esc_html__( 'محصولات پر فروش', 'woolentor' ),
                        'sale' => esc_html__( 'محصولات تخفيفي', 'woolentor' ),
                        'top_rated' => esc_html__( 'محصولات محبوب', 'woolentor' ),
                    ],
                ]
            );
           
            $this->add_control(
              'woolentor_product_grid_row',
              [
                 'label'   => __( 'ستون', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 1,
                 'min'     => 1,
                 'max'     => 1,
                 'step'    => 1,
              ]
            );

            $this->add_control(
              'woolentor_product_grid_products_count',
              [
                 'label'   => __( 'تعداد محصولات', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 4,
                 'min'     => 1,
                 'max'     => 100,
                 'step'    => 1,
              ]
            );

            $this->add_control(
                'woolentor_product_grid_categories',
                [
                    'label' => esc_html__( 'دسته بندي محصولات', 'woolentor' ),
                    'type' => Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple' => true,
                    'options' => woolentor_woocommerce_product_categories(),
                ]
            );
           

                   $this->end_controls_section();

        
	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
             
 

		   
		    
		   
		   $this->add_control(
'color_farnam_2',
			[
				'label' => __( 'رنگ پس زمینه اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mini-prodct-402' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'color_farnam_3',
			[
				'label' => __( 'رنگ پس زمینه باکس داخلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .mini-prodct-402-1' => 'background: {{VALUE}} !important',
				],
			]
           );

	
		   	 	   $this->add_control(
'color_farnam_6',
			[
				'label' => __( 'رنگ عنوان محصولات', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .min-mahsool-mk-4023-titlewslkjkj' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
	
		   
		   	   	 	   $this->add_control(
'color_farnam_7',
			[
				'label' => __( 'رنگ پس زمینه دکمه اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .ht-row.ns-402-197564876-000 .owl-nav button' => 'background: {{VALUE}} !important',
				],
			]
           );  
		   
		      	   	 	   $this->add_control(
'color_farnam_8',
			[
				'label' => __( 'رنگ ایکون دکمه اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .ht-row.ns-402-197564876-000 .owl-nav button' => 'color: {{VALUE}} !important',
				],
			]
           );  
		      $this->add_control(
'color_farnam_37',
			[
				'label' => __( 'رنگ هاور پس زمینه دکمه اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .ht-row.ns-402-197564876-000 .owl-nav button:hover' => 'background: {{VALUE}} !important',
				],
			]
           );  $this->add_control(
'color_farnam_327',
			[
				'label' => __( 'رنگ هاور متن دکمه اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .ht-row.ns-402-197564876-000 .owl-nav button:hover' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   		      	  
		   
		   		   
		   		      	   	 	   $this->add_control(
'color_farnam_10',
			[
				'label' => __( 'رنگ پس زمینه قیمت', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-mini-product' => 'background: {{VALUE}} !important',
				],
			]
           );  
		   
		         	   	 	   $this->add_control(
'color_farnam_11',
			[
				'label' => __( 'رنگ متن قیمت', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-mini-product' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
		   
		          	   	 	   $this->add_control(
'color_farnam_12',
			[
				'label' => __( 'رنگ واحد پول', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-mini-product .woocommerce-Price-currencySymbol' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
		   
		   	          	   	 	   $this->add_control(
'color_farnam_14',
			[
				'label' => __( 'رنگ پس زمینه تصویر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mini-product-add-to-ca44rt' => 'background: {{VALUE}} !important',
					'{{WRAPPER}} .mini-product-add-to-crrra44rt' => 'background: {{VALUE}} !important',
				],
			]
           );  
		          	   	 	   
		   
		   	   	   $this->add_control(
                        'titr-124444-44r45rw',
                        [
                            'label' => __( 'سایه باکس داخلی', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'selector' => '{{WRAPPER}} .mini-prodct-402-1',
			]
		);
				
				$this->add_control(
                        'titr-124444-44r464345rw',
                        [
                            'label' => __( 'سایه دور تصویر', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow34',
				'selector' => '{{WRAPPER}} .mini-product-add-to-ca44rt',
			]
		);
				
		   $this->add_responsive_control(
                        'farnamborder1',
                        [
                            'label' => esc_html__( 'گردی باکس اصلی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .mini-prodct-402' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );

  $this->add_responsive_control(
                        'farnamborder2',
                        [
                            'label' => esc_html__( 'گردی باکس داخلی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .mini-prodct-402-1' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
				  $this->add_responsive_control(
                        'farnamborder3',
                        [
                            'label' => esc_html__( 'گردی قیمت', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .price-mini-product' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
								  $this->add_responsive_control(
                        'farnamborder4',
                        [
                            'label' => esc_html__( 'گردی دور تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .mini-product-add-to-ca44rt' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                                '{{WRAPPER}} .mini-product-add-to-crrra44rt' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	
									  $this->add_responsive_control(
                        'farnamborder5',
                        [
                            'label' => esc_html__( 'گردی دکمه اسلایدر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .ht-row.ns-402-197564876-000 .owl-nav button' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	
					


        $this->end_controls_section();


    }

    protected function render( $instance = [] ) {

        $settings           = $this->get_settings_for_display();
        $product_type       = $this->get_settings_for_display('woolentor_product_grid_product_filter');
        $per_page           = $this->get_settings_for_display('woolentor_product_grid_products_count');
        $custom_order_ck    = $this->get_settings_for_display('custom_order');
        $orderby            = $this->get_settings_for_display('orderby');
        $order              = $this->get_settings_for_display('order');
        $columns            = $this->get_settings_for_display('woolentor_product_grid_column');
        $rows               = $this->get_settings_for_display('woolentor_product_grid_row');
        $tabuniqid          = $this->get_id();
        $proslider          = $this->get_settings_for_display('proslider');
        $producttab          = $this->get_settings_for_display('producttab');

        $is_rtl = is_rtl();
        $direction = $is_rtl ? 'rtl' : 'ltr';
        $slider_settings = [
           
        ];

        $slider_responsive_settings = [
            
        ];

        $slider_settings = array_merge($slider_settings, $slider_responsive_settings);

        // WooCommerce Category
        $args = array(
            'post_type'             => 'product',
            'post_status'           => 'publish',
            'ignore_sticky_posts'   => 1,
            'posts_per_page'        => $per_page,
        );

        switch( $product_type ){

                 case 'sale':
  $args['meta_key']   = '_sale_price';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;

            case 'featured':
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                    'operator' => 'IN',
                );
            break;

            case 'best_selling':
                $args['meta_key']   = 'total_sales';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;

            case 'top_rated': 
                $args['meta_key']   = '_wc_average_rating';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';          
            break;

            case 'mixed_order':
                $args['orderby']    = 'rand';
            break;

            default: /* Recent */
                $args['orderby']    = 'date';
                $args['order']      = 'desc';
            break;
        }

        // Custom Order
        if( $custom_order_ck == 'yes' ){
            $args['orderby'] = $orderby;
            $args['order'] = $order;
        }

        $get_product_categories = $settings['woolentor_product_grid_categories']; // get custom field value
        $product_cats = str_replace(' ', '', $get_product_categories);

        if ( "0" != $get_product_categories) {
            if( is_array($product_cats) && count($product_cats) > 0 ){
                $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'product_cat',
                        'terms' => $product_cats,
                        'field' => $field_name,
                        'include_children' => false
                    )
                );
            }
        }

        $products = new \WP_Query( $args );

        $tabmenu = 'yes';

        if( ($proslider == 'yes') && ( $producttab != 'yes' ) ){
            $collumval = 'slide-item ht-col-xs-12';
        }else{
            $collumval = 'product-list-off-401aswhg';
            if( $columns !='' ){
                if( $columns == 5){
                    $collumval = 'product-list-off-401aswhg';
                }else{
                    $colwidth = round(12/$columns);
                    $collumval = 'ht-col-lg-'.$colwidth.'product-list-off-401aswhg';
                }
            }
        }

        ?>
          
        <div class="product-style htpp ir-owl new-offer-401444545345fgteerrr">

            <?php if ( $producttab == 'yes' ) { ?>
                <div class="product-tab-list ht-text-center4">
  
                    </ul>
                </div>
            <?php }; ?>

            <?php if( is_array( $product_cats ) && (count( $product_cats ) > 0) && ( $producttab == 'yes' ) ): ?>
                
            <?php
                $j=0;
                foreach( $product_cats as $cats ):
                    $j++;
                    $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'product_cat',
                            'terms' => $cats,
                            'field' => $field_name,
                            'include_children' => false
                        )
                    );
                    $products = new \WP_Query( $args );
                    ?>
                
                <?php endforeach;?>

            <?php else:?>
                <div class="ht-row ns-402-197564876-000">
			
                 <script>           $(document).ready(function(){
$('.owl-offer-new1254w').owlCarousel({
    loop:true,
     autoplay:true,
    autoplayTimeout:7000,
    autoplayHoverPause:true,
    rtl: true,
    nav:true,
        margin:0,
    dots: false,
    responsive:{
        0:{
            items:1
        },
		   360:{
            items:2,
			        margin:0
        },
        850:{
            items:3
        },
        1200:{
            items:4
        }
    }
})
});</script>


   <div class="owl-offer-new1254w owl-carousel">

                        <div class="<?php echo esc_attr( $collumval );?>">
                            <?php
                                $k=1;
                                if( $products->have_posts() ):
                                    while( $products->have_posts() ): $products->the_post();
                            ?>
							<div class="mini-prodct-402">
							<a href="<?php the_permalink(); ?>">
														<div class="mini-prodct-402-1">



<div class="mini-product-402-2">
<div class="min-mahsool-mk-4023-titlewslkjkj">

<?php the_title(); ?>

</div>
<div class="price-mini-product">

<?php global $product; echo $product->get_price_html(); ?>


</div>
</div>

							</div>
							
							<div class="mini-product-add-to-cart">
							<div class="mini-product-add-to-ca44rt">
							<div class="mini-product-add-to-crrra44rt">
							<?php the_post_thumbnail('woocommerce_thumbnail'); ?>

							</div>	</div>	</div>
							</a>
							</div>
							
							
							
							




                           <?php if ($k % $rows == 0 && ($products->post_count != $k)) { ?>
                            </div>
                            <div class="<?php echo esc_attr($collumval );?>">
                                <?php } $k++; endwhile; wp_reset_postdata();  endif; ?>
                            </div>
                    <?php if( $proslider == 'yes' ){ echo '</div>';} ?>
                </div>       </div>
            <?php endif;?>

        </div>  


        <?php

    }


}


